﻿/*
	VERSION:		1.1
	1.1		Add:	includeSelf
				Add:	isShallow
	
	USAGE:
		#include "functions/recurseClips.as"
		recurseClips( targ_mc, function( thisItem ){
			thisItem.removeMovieClip();
			this.removeMovieClip();
		});
	
	WHAT IT'S FOR:
		This recursively calls a given function for a movieClip and EVERY child movieClip.
		includeSelf		(can optionally skip parent and only affect children)
		isShallow			(can be shallow and only affect immediate children  (1 level deep)
*/
function recurseClips( parent, doThis, includeSelf, isShallow ){
	// required params
	if( !parent )		return;
	if( !(parent instanceof MovieClip) )		return;
	if( !doThis )		return;
	// optional params
	if(includeSelf === undefined)		includeSelf = true;
	if(isShallow === undefined)			isShallow = false;
	// local vars
	var reportedPath;
	var actualPath;
	
	for(var nam in parent)
	{// for:  all variables in parent
		if( !nam )		continue;
		var thisChild = parent[nam];
		if(thisChild instanceof MovieClip){
			reportedPath = String(eval(thisChild._target));
			actualPath = String(eval(parent._target))+"."+nam;
			if(reportedPath.indexOf(actualPath) != -1 ){// if:  paths match
				if(isShallow)		doThis.call( thisChild, thisChild );
				if(!isShallow)	recurseClips( thisChild, doThis );
			}// if:  paths match
		}// if:  child is a movieClip
	}// for:  all variables in parent
	
	if(includeSelf)		doThis.call( parent, parent );
}// recurseClips()